#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <math.h>
#include <stdlib.h>
#include "_mpusbapi.h"


#define VERSION_MAJOR       6
#define VERSION_MINOR       00
#define EPSIZE 64               // endpoint packet size in bytes
#define USBTIMEOUT 200          // in milliseconds...
#define BOOT_EP_SIZE 64


typedef enum{
            READ_VERSION            = 0x00,
            READ_FLASH              = 0x01,
            WRITE_FLASH             = 0x02,
            ERASE_FLASH             = 0x03,
            READ_EEDATA             = 0x04,
            WRITE_EEDATA            = 0x05,
            READ_CONFIG             = 0x06,
            WRITE_CONFIG            = 0x07,
            UPDATE_LED              = 0x32,
			WINPIC_GETOKBUTTON 		= 0x50,
			WINPIC_GETDATAINBIT 	= 0x51,
			WINPIC_SETLEDS			= 0x52,
			WINPIC_SETVPP			= 0x53,
			WINPIC_SETVDD			= 0x54,
			WINPIC_SETCLOCKANDDATA	= 0x55,
			WINPIC_SETCLOCKENABLE	= 0x56,
			WINPIC_SETDATAENABLE	= 0x57,
			WINPIC_PULLMCLRTOGND	= 0x58,
			WINPIC_CONNECTTARGET	= 0x59,
			USB_CLOCK_SET_TIME      = 0x70,
			USB_CLOCK_GET_POWER     = 0x71,
			USB_CLOCK_GET_VOLTAGE   = 0x72,
			USB_CLOCK_SET_MODE      = 0x73,
			USB_CLOCK_GET_INFO      = 0x74,
			USB_CLOCK_SET_LV_TRIP   = 0x75,
			USB_CLOCK_SET_PWM       = 0x76,
			USB_CLOCK_SET_TIMEOUT   = 0x77,
    		USB_CLOCK_SET_DEFAULTS  = 0x78,
      		USB_CLOCK_RESET         = 0x79,
            USB_CLOCK_INFO_PACKET	= 0x7A,
            USB_CLOCK_SET_DISPLAY_TIMEOUT   = 0x7B,
            USB_CLOCK_SET_SCROLLING_MODE    = 0x7C,
            USB_CLOCK_SET_SENSE_RESISTOR    = 0x7D,
            USB_CLOCK_SET_VOLTAGE_REFERENCE = 0x7E,
           	USB_CLOCK_SET_AUTO_BACKLIGHT_MODE	=0x7F,
           	USB_CLOCK_SET_TWENTYFOURHOUR_MODE      =0x80,
            USB_CLOCK_SET_NOBATTERY                =0x81,
   			USB_CLOCK_SET_HYSTERESIS			=0x82,
            RESET                           = 0xFF
        }CMD;

typedef struct
            {
                byte low;                   //Little-endian order
                byte high;
                byte upper;
            }ADR;
        
typedef union _BOOT_DATA_PACKET
{
    byte _byte[BOOT_EP_SIZE];  // For Byte Access
    struct
    {
        byte cmd;
        byte len;
        ADR pAdr;
        byte data[EPSIZE-5];
    };
    
    	// for USB_CLOCK_SET_TIME
	struct
	{
		unsigned :8;

        byte 	hours;
		byte	minutes;
		byte 	seconds;
		byte	ydaylow;
		byte	ydayhigh;
		byte    mday;
		byte    wday;
		byte	month;
		byte	yearlow;
		byte	yearhigh;
		byte    isdst;
	};

    // for USB_CLOCK_SET_hysteresis
    struct
    {
        unsigned    :8;
        byte       sethysteresishigh;
        byte       sethysteresislow;
    };
    	
    // for USB_CLOCK_SET_MODE
    struct
    {
        unsigned :8;
        byte    mode;
    };

    // for USB_CLOCK_SET_24HOUR_TIME_MODE
    struct
    {
        unsigned   :8;
        byte    settwentyfourhourtime;
    };
    
    // for USB_CLOCK_SET_PWM
    struct
    {
        unsigned :8;
        byte    pwmduty;
    };

	 // for USB_CLOCK_SET_LV_TRIP
    struct
    {
        unsigned :8;

        byte    lvtriplow;
		byte	lvtriphigh;
    }; 

	// for USB_CLOCK_SET_TIMEOUT
    struct
    {
        unsigned    :8;

        byte    timeoutlow;
		byte	timeouthigh;
    };

    // for USB_CLOCK_SET_DISPLAY_TIMEOUT
    struct
    {
        unsigned    :8;
        byte    setdisplaytimeouthigh;
        byte    setdisplaytimeoutlow;
    };
    
    // for USB_CLOCK_SET_SCROLLING_MODE
    struct
    {
        unsigned    :8;
        byte	     setscrollingmode;
    };
    
    // for USB_CLOCK_SET_SENSE_RESISTOR
    struct
    {
        unsigned    :8;
        byte       setsenseresistorhigh;
        byte       setsenseresistorlow;
    };
    
    // for USB_CLOCK_SET_VOLTAGE_REFERENCE
    struct
    {
        unsigned    :8;
        byte        setvoltagerefhigh;
        byte        setvoltagereflow;
    };
    
    	// for USB_CLOCK_SET_AUTO_BACKLIGHT_MODE
	struct
	{
		unsigned	:8;
		byte		tosetautobacklightmode;
	};

	 // for USB_CLOCK_SET_NOBATTERY
    struct
    {
        unsigned :8;
        byte    setnobatterymode;
    };

   	// for USB_CLOCK_INFO_PACKET back to PC
	struct
	{
		unsigned :8;
		byte 	usbhours;
		byte	usbminutes;
		byte 	usbseconds;
		byte	usbydaylow;
		byte	usbydayhigh;
		byte	usbmday;
		byte	usbwday;
		byte	usbisdst;
		byte	usbmonth;
		byte	usbyearlow;
		byte	usbyearhigh;
		byte	usbmode;
		byte	an0low;
		byte	an0high;
		byte 	an1low;
		byte	an1high;
		byte	verlow;
		byte	verhigh;
		byte	usbpwmduty;
		byte	usbtimeoutlow;
		byte	usbtimeouthigh;
		byte	usblvtriplow;
		byte	usblvtriphigh;
		byte    actualtriplow;
        byte    actualtriphigh;
    	byte	lasthours;
		byte	lastminutes;
		byte	lastseconds;
		byte	lastydaylow;
		byte	lastydayhigh;
		byte 	lastwday;
		byte 	lastmday;
		byte	lastisdst;
		byte	lastmonth;
		byte	lastyearlow;
		byte	lastyearhigh;
		byte    currentPWMDuty;
		byte	usbregassumedvoltagelow;
		byte	usbregassumedvoltagehigh;
		byte	powermode;
		byte	senseresistorlow;
		byte	senseresistorhigh;
		byte	scrollingmode;
		byte	displaytimeoutlow;
		byte	displaytimeouthigh;
		byte	setautobacklightmode;
		byte    twentyfourhourtime;
        byte	usbsetnobattery;
   		byte	rtchigh;
		byte	rtclow;
		byte	displaycounthigh;
		byte	displaycountlow;
        byte    usbsyncNeeded;
        byte    batterychargepercent;
   		byte	usbhysteresishigh;
        byte    usbhysteresislow;
	};
	
} BOOT_DATA_PACKET;

#define MODE_DISPLAY_TIME_HH_MM             0       //Display Time HH:MM mode
#define MODE_DISPLAY_DATE_DD_MM             1       //Display Date DD:MM mode
#define MODE_DISPLAY_YEAR_YYYY              2       //Display Year YYYY mode
#define MODE_DISPLAY_TIME_MM_SS             3       //Display Time MM:SS mode
#define MODE_DISPLAY_CHARGING_CURRENT_MA    4       //Display Charging Current in mA mode
#define MODE_DISPLAY_SUPPLY_VOLTAGE         5       //Display Supply Voltage in mV mode
#define MODE_DISPLAY_CHARGE_STATE           6
#define MODE_DISPLAY_PWM_DUTY_CYCLE         7       //Display Backlight PWM Duty Cycle mode
#define MODE_DISPLAY_USB_STATE			    8       //Display USB connection status
#define MODE_DISPLAY_ALL                    9
#define MODE_DISPLAY_TIME_SCROLLING         10
#define MODE_DISPLAY_VERSION				11		//Display the Firmware version
#define MODE_MODULUS						12
//
// Global Vars
//
DWORD temp;
char vid_pid[]= "vid_04d8&pid_000b";    
char out_pipe[]= "\\MCHP_EP1";
char in_pipe[]= "\\MCHP_EP1";
HANDLE myOutPipe;
HANDLE myInPipe;
tm theLocalTime;
tm myUSBTime;
tm myLastTime;
int open=0;
byte current_command;                   // default value...
BOOLEAN bQuit=false;
char selection;
DWORD maxn;
DWORD res;
DWORD nb;
BOOT_DATA_PACKET datapacket;
BOOT_DATA_PACKET indatapacket;
int thehysteresis;
int an0, an1, v1, supplyvoltage;
int senseresistor, currentchargerate;
int currentPWMDuty;
int usbregassumedvoltage;
int lowpowerPWMDuty;
int timeoutperiodsecs, timeoutperiodmins, timeoutperiodhours;
int lowvoltagetrippoint, actualtrippoint;
int clockmode;
int scrollingmode;
int displaytimeoutperiodsecs, displaytimeoutperiodmins, displaytimeoutperiodhours;
int powermode;
//int batterycharge;
int batteryvoltage;
int autobacklightmode;
int twentyfourhourtime;
int nobattery;
int RTCcountdown;
int displayCountDown;
int RTCcountdownhours;
int RTCcountdownminutes;
int RTCcountdownseconds;
int displayCountDownhours;
int displayCountDownminutes;
int displayCountDownseconds;
int syncNeeded;
int thebatterychargepercent;

void GetSummary(void)
{
    HANDLE tempPipe = INVALID_HANDLE_VALUE;
    DWORD count = 0;
    DWORD max_count;

    max_count = MPUSBGetDeviceCount(vid_pid);

    printf("\r\n%d device(s) with %s currently attached\r\n",max_count,vid_pid);

    // Note:
    // The total number of devices using the generic driver could be
    // bigger than max_count. They could have different vid & pid numbers.
    // This means if max_count is 2, the valid instance index do not
    // necessary have to be '0' and '1'.
    //
    // Below is a sample code for searching for all valid instance indexes.
    // MAX_NUM_MPUSB_DEV is defined in _mpusbapi.h
    
    count = 0;
    for(int i = 0; i < MAX_NUM_MPUSB_DEV; i++)
    {
        tempPipe = MPUSBOpen(i,vid_pid,NULL,MP_READ,0);
        if(tempPipe != INVALID_HANDLE_VALUE)
        {
            printf("Instance Index # %d\r\n",i);
            MPUSBClose(tempPipe);
            count++;
        }
        if(count == max_count) break;
    }//end for
    printf("\r\n");
}//end GetSummary

void
hex_print(byte* data, int length)
{
	int ptr = 0;
	for(;ptr < length;ptr++)
	{
		printf("0x%02x ",(unsigned char)*(data+ptr));
	}
}

void showPacket(byte *pp, int total)
{
 int u, v;
     for(u=0; u<total; u++)
     {
     printf(" "); 
     hex_print(pp, 1); 
     pp++;
     if((u & 0x0007)==0x0007){
                pp-=8;
                printf("  ");
                for(v=0; v<8; v++)printf("%c",*pp++);
                printf("\n");
            }
     }  
}

void updateInfo(BOOT_DATA_PACKET* datap)
{
    int i;
    time_t t;
    const time_t *ltm;
    double f;
      
    t=time(NULL);
    ltm=&t;
    myUSBTime=*localtime(ltm);   
    t=time(NULL);
    ltm=&t;
    myLastTime=*localtime(ltm);
    t=time(NULL);
    ltm=&t;
    theLocalTime=*localtime(ltm);
    // 
    myLastTime.tm_hour=datap->lasthours;
    myLastTime.tm_min=datap->lastminutes;
    myLastTime.tm_sec=datap->lastseconds;
    myLastTime.tm_isdst=datap->lastisdst;
    myLastTime.tm_mon=datap->lastmonth;
    i=(datap->lastyearhigh<<8)+datap->lastyearlow;
    myLastTime.tm_year=i;
    myLastTime.tm_wday=datap->lastwday;
    myLastTime.tm_mday=datap->lastmday;
    myLastTime.tm_yday=(datap->lastydayhigh<<8)+datap->lastydaylow;
    //
    myUSBTime.tm_hour=datap->usbhours;
    myUSBTime.tm_min=datap->usbminutes;
    myUSBTime.tm_sec=datap->usbseconds;
    myUSBTime.tm_isdst=datap->usbisdst;
    myUSBTime.tm_mon=datap->usbmonth;
    i=(datap->usbyearhigh<<8)+datap->usbyearlow;
    myUSBTime.tm_year=i;
    myUSBTime.tm_wday=datap->usbwday;
    myUSBTime.tm_mday=datap->usbmday;
    myUSBTime.tm_yday=(datap->usbydayhigh<<8)+datap->usbydaylow;
    //
    an0=(datap->an0high<<8)+datap->an0low;
    usbregassumedvoltage=(datap->usbregassumedvoltagehigh<<8)+datap->usbregassumedvoltagelow;
    if(an0>0)supplyvoltage=usbregassumedvoltage*1023/an0; else supplyvoltage=0;
    an1=(datap->an1high<<8)+datap->an1low;
    v1=supplyvoltage*an1/1023;
    senseresistor=((datap->senseresistorhigh<<8)+datap->senseresistorlow);
    if(senseresistor>0)currentchargerate=1000.0*v1/senseresistor; else currentchargerate=0;
    if(v1!=0){
              batteryvoltage=supplyvoltage-v1; 
              }
              else 
              {
              batteryvoltage=0;
              }
    currentPWMDuty=datap->currentPWMDuty;
    lowpowerPWMDuty=datap->usbpwmduty;
    lowvoltagetrippoint=(datap->usblvtriphigh<<8)+(datap->usblvtriplow);
    actualtrippoint=(datap->actualtriphigh<<8)+(datap->actualtriplow);
    i=(datap->usbtimeouthigh<<8)+(datap->usbtimeoutlow);
    timeoutperiodhours=(int)(i/3600);
    i=i%3600;
    timeoutperiodmins=(int)(i/60);
    i=i%60;
    timeoutperiodsecs=i;
    clockmode=datap->usbmode;
    powermode=datap->powermode;
    scrollingmode=datap->scrollingmode;
    i=(datap->displaytimeouthigh<<8)+(datap->displaytimeoutlow);
    displaytimeoutperiodhours=(int)(i/3600);
    i=i%3600;
    displaytimeoutperiodmins=(int)(i/60);
    i=i%60;
    displaytimeoutperiodsecs=i;
    autobacklightmode=datap->setautobacklightmode;
    twentyfourhourtime=datap->twentyfourhourtime;
    nobattery=datap->usbsetnobattery;
    RTCcountdown=(datap->rtchigh<<8)+(datap->rtclow);
    displayCountDown=(datap->displaycounthigh<<8)+(datap->displaycountlow);
    i=RTCcountdown;
    RTCcountdownhours=(int)(i/3600);
    i=i%3600;
    RTCcountdownminutes=(int)(i/60);
    i=i%60;
    RTCcountdownseconds=i;
    i=displayCountDown;
    displayCountDownhours=(int)(i/3600);
    i=i%3600;
    displayCountDownminutes=(int)(i/60);
    i=i%60;
    displayCountDownseconds=i;    
    syncNeeded=datap->usbsyncNeeded;
    thebatterychargepercent=datap->batterychargepercent;
    thehysteresis=(datap->usbhysteresishigh<<8)+datap->usbhysteresislow;
}

void showTimeStatus(void)
{
    double diff;
    double denominator;
    double f, g;
    double error;
    tm tone, ttwo, tthree;
    time_t t1, t2, t3;
    
    tone.tm_hour=myUSBTime.tm_hour;
    tone.tm_min=myUSBTime.tm_min;
    tone.tm_sec=myUSBTime.tm_sec;
    tone.tm_mday=myUSBTime.tm_mday;
    tone.tm_yday=myUSBTime.tm_yday;
    tone.tm_wday=myUSBTime.tm_wday;
    tone.tm_mon=myUSBTime.tm_mon;
    tone.tm_year=myUSBTime.tm_year;
    tone.tm_isdst=0;
    
    ttwo.tm_hour=myLastTime.tm_hour;
    ttwo.tm_min=myLastTime.tm_min;
    ttwo.tm_sec=myLastTime.tm_sec;
    ttwo.tm_mday=myLastTime.tm_mday;
    ttwo.tm_yday=myLastTime.tm_yday;
    ttwo.tm_wday=myLastTime.tm_wday;
    ttwo.tm_mon=myLastTime.tm_mon;
    ttwo.tm_year=myLastTime.tm_year;
    ttwo.tm_isdst=0;
       
    tthree.tm_hour=theLocalTime.tm_hour;
    tthree.tm_min=theLocalTime.tm_min;
    tthree.tm_sec=theLocalTime.tm_sec;
    tthree.tm_mday=theLocalTime.tm_mday;
    tthree.tm_yday=theLocalTime.tm_yday;
    tthree.tm_wday=theLocalTime.tm_wday;
    tthree.tm_mon=theLocalTime.tm_mon;
    tthree.tm_year=theLocalTime.tm_year;
    tthree.tm_isdst=0;
    
    t1=mktime(&tone); // USB time
    t2=mktime(&ttwo); // Last sync time
    t3=mktime(&tthree); // local time
    f=abs(difftime(t1, t3));
    diff=f;
    g=abs(difftime(t1, t2));
    if(g>0.0)f=(f*1000000.0/g); //f is now the relative error in ppm (parts per million)
    else f=0.0;
    error=f;
    //
    if(syncNeeded!=0)
    {
    printf("N/A\n");
    } else
    {
    if(diff>300)
    {
      printf("Very Poor Accuracy");
    } else
    if((diff>60)&&(diff<=300))
    {
      printf("Poor Accuracy");
    } else
    if((diff<=60)&&(diff>20))
    {
      printf("Moderate Accuracy");
    } else
    if((diff>5)&&(diff<=20))
    {
      printf("Good Accuracy");
    } else 
    if((diff>1)&&(diff<=5))
    {
       printf("Very Good Accuracy");
    } else
    if(diff<=1)
    {
       printf("Excellent Accuracy");
    } 
    printf("\n");
    }
}

void showAbsoluteTimeError(void)
{
    double diff;
    double denominator;
    double f, g;
    double error;
    tm tone, ttwo, tthree;
    time_t t1, t2, t3;
    
    tone.tm_hour=myUSBTime.tm_hour;
    tone.tm_min=myUSBTime.tm_min;
    tone.tm_sec=myUSBTime.tm_sec;
    tone.tm_mday=myUSBTime.tm_mday;
    tone.tm_yday=myUSBTime.tm_yday;
    tone.tm_wday=myUSBTime.tm_wday;
    tone.tm_mon=myUSBTime.tm_mon;
    tone.tm_year=myUSBTime.tm_year;
    tone.tm_isdst=0;
    
    ttwo.tm_hour=myLastTime.tm_hour;
    ttwo.tm_min=myLastTime.tm_min;
    ttwo.tm_sec=myLastTime.tm_sec;
    ttwo.tm_mday=myLastTime.tm_mday;
    ttwo.tm_yday=myLastTime.tm_yday;
    ttwo.tm_wday=myLastTime.tm_wday;
    ttwo.tm_mon=myLastTime.tm_mon;
    ttwo.tm_year=myLastTime.tm_year;
    ttwo.tm_isdst=0;
       
    tthree.tm_hour=theLocalTime.tm_hour;
    tthree.tm_min=theLocalTime.tm_min;
    tthree.tm_sec=theLocalTime.tm_sec;
    tthree.tm_mday=theLocalTime.tm_mday;
    tthree.tm_yday=theLocalTime.tm_yday;
    tthree.tm_wday=theLocalTime.tm_wday;
    tthree.tm_mon=theLocalTime.tm_mon;
    tthree.tm_year=theLocalTime.tm_year;
    tthree.tm_isdst=0;
    
    t1=mktime(&tone); // USB time
    t2=mktime(&ttwo); // Last sync time
    t3=mktime(&tthree); // local time
    f=abs(difftime(t1, t3));
    diff=f;
    g=abs(difftime(t1, t2));
    if(g>0.0)f=(f*1000000.0/g); //f is now the relative error in ppm (parts per million)
    else f=0.0;
    error=f;
    //
    if(syncNeeded!=0)
    {
    printf("N/A\n");
    } else
    {
    if(diff>300)
    {
      // 241 is the extended ASCII code for +/-                                                                                          
      printf("Worse than %c5 minutes", 241);
    } else
    if((diff>60)&&(diff<=300))
    {
      printf("Within %c5 minutes", 241);
    } else
    if((diff<=60)&&(diff>20))
    {
      printf("Within %c1 minute", 241);
    } else
    if((diff>5)&&(diff<=20))
    {
      printf("Within %c20 seconds", 241);
    } else 
    if((diff>1)&&(diff<=5))
    {
       printf("Within %c5 seconds", 241);
    } else
    if(diff<=1)
    {
       printf("Within %c1 second", 241);
    } 
    printf("\n");
    }
}

void showRelativeTimeError(void)
{
    double diff;
    double denominator;
    double f, g;
    double error;
    tm tone, ttwo, tthree;
    time_t t1, t2, t3;
    
    tone.tm_hour=myUSBTime.tm_hour;
    tone.tm_min=myUSBTime.tm_min;
    tone.tm_sec=myUSBTime.tm_sec;
    tone.tm_mday=myUSBTime.tm_mday;
    tone.tm_yday=myUSBTime.tm_yday;
    tone.tm_wday=myUSBTime.tm_wday;
    tone.tm_mon=myUSBTime.tm_mon;
    tone.tm_year=myUSBTime.tm_year;
    tone.tm_isdst=0;
    
    ttwo.tm_hour=myLastTime.tm_hour;
    ttwo.tm_min=myLastTime.tm_min;
    ttwo.tm_sec=myLastTime.tm_sec;
    ttwo.tm_mday=myLastTime.tm_mday;
    ttwo.tm_yday=myLastTime.tm_yday;
    ttwo.tm_wday=myLastTime.tm_wday;
    ttwo.tm_mon=myLastTime.tm_mon;
    ttwo.tm_year=myLastTime.tm_year;
    ttwo.tm_isdst=0;
       
    tthree.tm_hour=theLocalTime.tm_hour;
    tthree.tm_min=theLocalTime.tm_min;
    tthree.tm_sec=theLocalTime.tm_sec;
    tthree.tm_mday=theLocalTime.tm_mday;
    tthree.tm_yday=theLocalTime.tm_yday;
    tthree.tm_wday=theLocalTime.tm_wday;
    tthree.tm_mon=theLocalTime.tm_mon;
    tthree.tm_year=theLocalTime.tm_year;
    tthree.tm_isdst=0;
    
    t1=mktime(&tone); // USB time
    t2=mktime(&ttwo); // Last sync time
    t3=mktime(&tthree); // local time
    f=abs(difftime(t1, t3));
    diff=f;
    g=abs(difftime(t1, t2));
    if(g>0.0)f=(f*1000000.0/g); //f is now the relative error in ppm (parts per million)
    else f=0.0;
    error=f;
    //
    if(syncNeeded!=0)
    {
    printf("N/A\n");
    } else
    {
    if(error<10000.0)
    {
                     if(error<=20)
                     {
                     printf("Negligible (<20ppm)\n");
                     } else
                     if((error>20)&&(error<173))
                     {
                     f=24.0*36.0*error/10000.0;  // f is now seconds per day error
                     printf("%c%d ppm or %c%0.2f seconds per day\n", 241, (int)error, 241, f);
                     } else
                     {
                     f=24.0*6.0*error/100000.0;
                     printf("%c%d ppm or %c%0.2f minutes per day\n", 241, (int)error, 241, f);      
                     }
    }
    else
    {
    // error is greater than or equal to 10000 ppm or 1% so
    // display as a percentage in this case.
    error=error/10000.0;
    printf("%c%0.2f%c\n", 241, error, '%');
    }
  }
}

void showMode(int iclockmode)
{
    if(iclockmode==MODE_DISPLAY_TIME_HH_MM){
             if(twentyfourhourtime==0)printf("Display Time HH:MM (24 hour time)");
             else
             printf("Display Time HH:MM (12 hour time)");              
            }
    else
    if(iclockmode==MODE_DISPLAY_TIME_MM_SS)printf("Display Time MM:SS");
    else
    if(iclockmode==MODE_DISPLAY_DATE_DD_MM)printf("Display Date DD:MM");
    else
    if(iclockmode==MODE_DISPLAY_YEAR_YYYY)printf("Display Year YYYY");
    else
    if(iclockmode==MODE_DISPLAY_CHARGING_CURRENT_MA)printf("Display Charging Current in A");
    else
    if(iclockmode==MODE_DISPLAY_SUPPLY_VOLTAGE)printf("Supply Voltage in V");
    else
    if(iclockmode==MODE_DISPLAY_CHARGE_STATE)printf("Battery Charge as %c",'%');
    else
    if(iclockmode==MODE_DISPLAY_PWM_DUTY_CYCLE)printf("Backlight PWM Duty Cycle/Power Mode");
    else
    if(iclockmode==MODE_DISPLAY_USB_STATE)printf("USB enumeration state");
    else
    if(iclockmode==MODE_DISPLAY_ALL)printf("All in Scrolling Mode");
    else
    if(iclockmode==MODE_DISPLAY_TIME_SCROLLING)printf("Time in Scrolling Mode");
    else
    if(iclockmode==MODE_DISPLAY_VERSION)printf("Firmare version");
    else
    printf("Undefined");
}

void showAutoBackLightMode(int aut)
{
    if(aut==0)printf("Automatic backlight disabled");   
    else if(aut==1)printf("Auto Backlighting Enabled 6pm-6am");
    else printf("Auto Backlighting Enabled All Day");
}

void showInfo(BOOT_DATA_PACKET* datap)
{
    //
    //
    updateInfo(datap);
    //
    printf("USB Clock Firmware Version...: %d.%2.2d \n", datap->verhigh, datap->verlow);
    //
    printf("PC Time......................: %s", asctime(&theLocalTime));
    //
    printf("USB Clock Time...............: %s", asctime(&myUSBTime));
    //
    if(syncNeeded!=0)
    printf("Last Synchronisation.........: N/A\n");
    else
    printf("Last Synchronisation.........: %s", asctime(&myLastTime));
    //
    printf("Time Status..................: ");
    showTimeStatus();
    printf("Absolute Time Error..........: ");
    showAbsoluteTimeError();
    printf("Relative Time Error..........: ");
    showRelativeTimeError();
    //
    printf("Supply Voltage...............: %d mV (Ref: %d mV)\n", supplyvoltage, usbregassumedvoltage);
    //
    printf("Actual Low Voltage Trip Point: %d mV (Hysteresis: %d mV)\n",actualtrippoint, thehysteresis);
    //
    printf("Set Low Voltage trip point...: %d mV\n", lowvoltagetrippoint);
    //
    printf("Power mode...................: ");
    if(powermode==0)
    {
      printf("High Power (>1mA)");
    } 
    else
    if(powermode==1)
    {
        printf("Low Power (~1mA)");
    } else
    if((powermode & 0x04)!=0)
    {
        printf("Extra Low Power (~50uA)");
    } else
    {
        printf("Low Power Intermediate (~1mA) ");
    }
    printf(" (PowerMode: %d) \n", powermode);
    //
    //
    
    printf("Battery Mode.................: ");
    if(nobattery==0){
    printf("Battery Installed Operation\n"); 
    printf("Battery Charge Current.......: %d mA (Ref: %d m%c)\n", currentchargerate, senseresistor, 234);
    //
    printf("Battery Voltage..............: %d mV%\n", batteryvoltage);
    //
    printf("Battery Charge...............: %d%c\n", thebatterychargepercent, '%');
    //
    }
    else 
    {
    printf("No Battery Installed Operation\n");
    printf("Battery Charge Rate..........: N/A\n");
    //
    printf("Battery Voltage..............: N/A\n");
    //
    printf("Battery Charge...............: N/A\n");
    }
    printf("Current Backlight PWM Duty...: %d%c\n", currentPWMDuty, '%');
    //
    //printf("Running on battery since this Time...: \n");
    //
    printf("Set PWM Duty cycle...........: %d%c\n", lowpowerPWMDuty, '%');
    //
    printf("Auto Backlighting mode.......: ");
    showAutoBackLightMode(3 & autobacklightmode);
    printf("\n");
    printf("State of Auto Backlight......: ");
    if((autobacklightmode & 0x80)!=0)
     printf("Auto Backlighting Operating\n");
    else
     printf("Auto Backlighting Not Operating\n");
    //
    printf("Backlight Timeout period.....: %d hours %d mins %d seconds\n", timeoutperiodhours, timeoutperiodmins, timeoutperiodsecs);
    printf("Backlight Timeout remaining..: %d hours %d mins %d seconds\n", RTCcountdownhours, RTCcountdownminutes, RTCcountdownseconds);
    printf("Display Timeout period.......: %d hours %d mins %d seconds\n", displaytimeoutperiodhours, displaytimeoutperiodmins, displaytimeoutperiodsecs);
    printf("Display Timeout remaining....: %d hours %d mins %d seconds\n", displayCountDownhours, displayCountDownminutes, displayCountDownseconds);
    //
    printf("Current Display Mode.........: ");
    showMode(clockmode);
    printf("\n");
    printf("Current Default Display Mode.: ");
    showMode(scrollingmode);
    printf("\n");
    //
}

int updateTime(void)
{

        int i;
        time_t t;
        const time_t *ltm;
        t=time(NULL);
        ltm=&t;
        theLocalTime=*localtime(ltm);
        i=theLocalTime.tm_sec;
        while(i==theLocalTime.tm_sec){
            t=time(NULL);
            ltm=&t;
            theLocalTime=*localtime(ltm);
        }
//        printf("Hours: %d Minutes: %d Seconds: %d\r\n",theLocalTime->tm_hour, theLocalTime->tm_min, theLocalTime->tm_sec);
        return 0;
}

void showTime(void)
{
        updateTime();
        printf("Time is: ");
        printf("%s", asctime(&theLocalTime));
}

int showHelpScreen(void)
{
 int i;
               
        printf("Usage      : usbclock.exe <option> <option> .... <option>\n");
        printf(" -s        : synchronise the USB Clock with this PC's clock, eg: usbclock -s\n");
        printf(" -i        : get information about the USB Clock's current settings, eg. usbclock -i\n");
        printf(" -z:DD     : set the USB Clock's default display mode, eg. usbclock -z:1\n");
        printf(" -m:DD     : set the USB Clock's display mode, eg. usbclock -m:0\n");
        for(i=0; i<MODE_MODULUS; i++)
        {
        printf("           : DD is %d selects ", i);
        showMode(i);
        printf("\n");
        }         
        printf(" -p:PPP    : set the USB Clock's normal PWM Duty cycle for backlighting, eg. usbclock -p:40\n");
        printf("           : where PPP is a percentage from 0 to 100\n");
        printf(" -t:SSSSS  : set the USB Clock's backlighting timeout period, eg. usbclock -t:5 for 5 seconds\n");
        printf(" -d:SSSSS  : set the USB Clock's display timeout period, eg. usbclock -d:60 for 1 minute\n");        
        printf("           : where SSSSS is a number from 0 to 32000 indicating the number of seconds\n");
        printf(" -v:VVVV   : set the USB Clock's voltage reference, eg. usbclock -v:3300 for 3.3V\n");
        printf(" -l:VVVV   : set the USB Clock's low voltage trip point, eg. usbclock -l:3200 for 3.2V\n");
        printf(" -k:VVVV   : set the USB Clock's hysteresis, eg. usbclock -k:250 to select 0.25V\n");
        printf("           : where VVVV is the value in mV\n");
        // 234 is the extended ASCII code for Omega
        printf(" -c:RRRR   : set the USB Clock's reference sense resistor, eg: usbclock -c:1650 for 1.65%c\n", 234);  
        
        printf("           : where RRRR is the value in m%c\n", 234);
        printf(" -a:A      : set the USB Clock's auto back light mode, eg. usbclock -a:1 to turn on auto backlighting\n");
        for(i=0; i<3; i++)
        {
        printf("           : A is %d selects", i);
        showAutoBackLightMode(i & 3);
        printf("\n");
        }
        printf(" -y:Y      : set the USB Clock's display of time mode, eg. -y:1 to use 12 hour time\n");
        printf("           : Y is 0 selects 24 hour time\n");
        printf("           : Y is 1 selects 12 hour time\n");
        printf(" -b:B      : set the USB Clock's battery installed mode, eg. -b:1 to use without a battery\n");
        printf("           : B is 0 selects normal operation with battery installed\n");
        printf("           : B is 1 selects operation with USB power only, no battery installed\n");

        printf(" -r        : reset the USB Clock and restore defaults, eg. usbclock -r\n");
}

int openDevice(void)
{
 if(open==0){
                maxn = MPUSBGetDeviceCount(vid_pid);
                myOutPipe = INVALID_HANDLE_VALUE;
                myOutPipe = MPUSBOpen(0,vid_pid,out_pipe,MP_WRITE,0);
                myInPipe  = INVALID_HANDLE_VALUE;
                myInPipe  = MPUSBOpen(0,vid_pid,in_pipe,MP_READ,0);
                //printf("USB Device Open...... ");
                if((myInPipe!=INVALID_HANDLE_VALUE)&&(myOutPipe!=INVALID_HANDLE_VALUE))
                {
                 //printf("Ok.\n");
                 open=1;
                 }
                 else
                 {
                 //printf("Error.\n");
                 open=0;
                 }
                }
                //else printf("Device is already open.\n");
   return open;
}

void printFailedToOpenDeviceMessage(void)
{
printf("Failed to Open Device.\nIs the USB Clock connected? If so, try unplugging and reconnecting the USB Clock.\n");
}

int main(int argc, char *argv[])
{
    int i, j, k, m;
    unsigned int myargument;
    open=0;
    printf("USB Clock Interface. Ver: %d.%2.2d M.G. May, Aug, 2008.\n", VERSION_MAJOR, VERSION_MINOR);
    temp=MPUSBGetDLLVersion();
    printf("MPUSBAPI Version: %d.%d",HIWORD(temp),LOWORD(temp));
    //printf("Size of datapacket......");
    if(sizeof(datapacket)==EPSIZE)printf("...Ok.\n"); else {
                                                    printf("...DataPacket Size Error.\n"); 
                                                    printf("Size is: %d.\nShould be: %d.\n", sizeof(datapacket), EPSIZE);
                                                  return -1; }
                                                        
    for(i=0; i<EPSIZE;i++){ datapacket._byte[i]=0; indatapacket._byte[i]=0; }
    myOutPipe= myInPipe = INVALID_HANDLE_VALUE;
 
    if(argc==1)
    {
           //  synchronise command if no arguments
                    i=openDevice();
                    if(i==0)
                    {
                        printFailedToOpenDeviceMessage();
                    } else
                    if(i==1)
                    {
                        datapacket.cmd=USB_CLOCK_SET_TIME;
                        showTime();
                        printf("Synchronising with the USB Clock...");
                        updateTime();
                        datapacket.hours=theLocalTime.tm_hour;
                        datapacket.minutes=theLocalTime.tm_min;
                        datapacket.seconds=theLocalTime.tm_sec;
                        datapacket.wday=theLocalTime.tm_wday;
                        datapacket.ydaylow=theLocalTime.tm_yday;
                        datapacket.ydayhigh=(theLocalTime.tm_yday>>8);
                        datapacket.mday=theLocalTime.tm_mday;
                        datapacket.month=theLocalTime.tm_mon;
                        datapacket.isdst=theLocalTime.tm_isdst;
                        j=theLocalTime.tm_year;
                        datapacket.yearlow=j;
                        datapacket.yearhigh=(j>>8);
                        res=MPUSBWrite(myOutPipe,&datapacket,EPSIZE,&nb,USBTIMEOUT);
                        if(res==MPUSB_SUCCESS)
                        {
                        printf("Ok.\n");
                        printf("Verifying...");
                        res=MPUSBRead(myInPipe, &indatapacket, 64, &nb, 500);
                        if(res==MPUSB_SUCCESS)
                        {
                        printf("Ok.\n");
                        }
                        else
                        {
                        printf("Error.\n");
                        }
                    }
                 }
                 else   
                 {
                 printf("Device is not open!\n");
                 }                                        
    }
    else
    if(argc>1)
    { 
        m=1;
        while(m<argc)
        {
        if(argv[m][0]=='-')
            {
                if(argv[m][1]=='s')
                {
                    //  synchronise command
                    i=openDevice();
                    if(i==0)
                    {
                        printFailedToOpenDeviceMessage();
                    } else
                    if(i==1)
                    {
                        datapacket.cmd=USB_CLOCK_SET_TIME;
                        showTime();
                        printf("Synchronising with the USB Clock...");
                        updateTime();
                        datapacket.hours=theLocalTime.tm_hour;
                        datapacket.minutes=theLocalTime.tm_min;
                        datapacket.seconds=theLocalTime.tm_sec;
                        datapacket.wday=theLocalTime.tm_wday;
                        datapacket.ydaylow=theLocalTime.tm_yday;
                        datapacket.ydayhigh=(theLocalTime.tm_yday>>8);
                        datapacket.mday=theLocalTime.tm_mday;
                        datapacket.month=theLocalTime.tm_mon;
                        datapacket.isdst=theLocalTime.tm_isdst;
                        j=theLocalTime.tm_year;
                        datapacket.yearlow=j;
                        datapacket.yearhigh=(j>>8);
                        res=MPUSBWrite(myOutPipe,&datapacket,EPSIZE,&nb,USBTIMEOUT);
                        if(res==MPUSB_SUCCESS)
                        {
                        printf("Ok.\n");
                        printf("Verifying...");
                        res=MPUSBRead(myInPipe, &indatapacket, 64, &nb, 500);
                        if(res==MPUSB_SUCCESS)
                        {
                        printf("Ok.\n");
                        }
                        else
                        {
                        printf("Error.\n");
                        }
                    }
                 }
                 else   
                 {
                        printf("Device is not open!\n");
                 }                              
                }                  
          /*      else
                if(argv[m][1]=='c')
                {
                    //  measure the power consumption 
                    i=openDevice();
                    if(i==0)
                    {
                        printFailedToOpenDeviceMessage();
                        
                    } else
                    if(i==1)
                    {
                        showTime();
                        printf("Checking power consumption...");
                        datapacket.cmd=USB_CLOCK_GET_POWER;
                        res=MPUSBWrite(myOutPipe,&datapacket,EPSIZE,&nb,USBTIMEOUT);
                        if(res==MPUSB_SUCCESS)
                        {
                        res=MPUSBRead(myInPipe, &indatapacket, 64, &nb, 500);
                        if(res==MPUSB_SUCCESS)
                        {
                        printf("Ok.\n");
                        }
                        else
                        {
                        printf("Error.\n");
                        }
                        } else printf("Error.\n");
                        
                    } else
                    {
                        printf("Device is not open!\n");
                    }  
                } else
                if(argv[m][1]=='b')
                {
                    //  measure supply voltage
                    i=openDevice();
                    if(i==0)
                    {
                        printFailedToOpenDeviceMessage();    
                    } else
                    if(i==1)
                    {
                        showTime();
                        printf("Checking supply voltage...");
                        datapacket.cmd=USB_CLOCK_GET_VOLTAGE;
                        res=MPUSBWrite(myOutPipe,&datapacket,EPSIZE,&nb,USBTIMEOUT);
                        if(res==MPUSB_SUCCESS)
                        {
                        res=MPUSBRead(myInPipe, &indatapacket, 64, &nb, 500);
                        if(res==MPUSB_SUCCESS)
                        {
                        printf("Ok.\n");
                        }
                        else
                        {
                        printf("Error.\n");
                        }
                        } else printf("Error.\n");
                        
                    } else
                    {
                        printf("Device is not open!\n");
                    }  
                } 
                */
                else
                if(argv[m][1]=='m')
                {
                    //  set the mode
                    myargument=0;
                    if(argv[m][2]==':')
                    {
                        myargument=(int)atof(&argv[m][3]);
                        i=openDevice();
                        if(i==0)
                        {
                        printFailedToOpenDeviceMessage();
                        } else
                        if(i==1)
                        {
                        printf("Setting the operating mode to: %d ...", (int)myargument);
                        datapacket.cmd=USB_CLOCK_SET_MODE;
                        datapacket.mode=(byte)myargument;
                        res=MPUSBWrite(myOutPipe,&datapacket,EPSIZE,&nb,USBTIMEOUT);
                        if(res==MPUSB_SUCCESS)
                        {
                        res=MPUSBRead(myInPipe, &indatapacket, 64, &nb, 500);
                        if(res==MPUSB_SUCCESS)
                        {
                        printf("Ok.\n");
                        if(m+1==argc)showInfo(&indatapacket);
                        }
                        else
                        {
                        printf("Error.\n");
                        }
                        } else printf("Error.\n");
                        
                        } else
                        {
                        printf("Device is not open!\n");
                        }
                    } else printf("Syntax error. Please provide an argument.\n");
              
                } else
                if(argv[m][1]=='i')
                {
                    //  get information about the current settings of the USB Clock
                    i=openDevice();
                    if(i==0)
                    {
                        printFailedToOpenDeviceMessage();    
                    } else
                    if(i==1)
                    {
                        printf("Gathering Information about the connected USB Clock...");
                        datapacket.cmd=USB_CLOCK_GET_INFO;
                        res=MPUSBWrite(myOutPipe,&datapacket,EPSIZE,&nb,USBTIMEOUT);
                        if(res==MPUSB_SUCCESS)
                        {
                        res=MPUSBRead(myInPipe, &indatapacket, 64, &nb, 500);
                        if(res==MPUSB_SUCCESS)
                        {
                        printf("Ok.\n");
                        if(m+1==argc)showInfo(&indatapacket);
                        }
                        else
                        {
                        printf("Error.\n");
                        }
                        } else printf("Error.\n");
                        
                    } else
                    {
                        printf("Device is not open!\n");
                    }  
                 
                } else
                if(argv[m][1]=='l')
                {
                    //  set the USB clock's low voltage trip point
                    if(argv[m][2]==':')
                    {
                        myargument=(int)atof(&argv[m][3]);
                        if(myargument<2170)myargument=2170; else if(myargument>=5500)myargument=5500;
                        i=openDevice();
                        if(i==0)
                        {
                        printFailedToOpenDeviceMessage();
                        } else
                        if(i==1)
                        {
                        j=(int)(myargument);
                        printf("Setting the low voltage trip point to: %d mV ...",j);
                        datapacket.cmd=USB_CLOCK_SET_LV_TRIP;
                        datapacket.lvtriplow=j;
                        datapacket.lvtriphigh=(j>>8);
                        res=MPUSBWrite(myOutPipe,&datapacket,EPSIZE,&nb,USBTIMEOUT);
                        if(res==MPUSB_SUCCESS)
                        {
                        res=MPUSBRead(myInPipe, &indatapacket, 64, &nb, 500);
                        if(res==MPUSB_SUCCESS)
                        {
                        printf("Ok.\n");
                        if(m+1==argc)showInfo(&indatapacket);
                        }
                        else
                        {
                        printf("Error.\n");
                        }
                        } else printf("Error.\n");
                        
                        } else
                        {
                        printf("Device is not open!\n");
                        }
                    } else printf("Syntax error. Please provide an argument.\n");
                } else
                if(argv[m][1]=='k')
                {
                    //  set the USB clock's hysteresis
                    if(argv[m][2]==':')
                    {
                        myargument=(int)atof(&argv[m][3]);
                        if(myargument<0)myargument=0; else if(myargument>=5500)myargument=5500;
                        i=openDevice();
                        if(i==0)
                        {
                        printFailedToOpenDeviceMessage();
                        } else
                        if(i==1)
                        {
                        j=(int)(myargument);
                        printf("Setting the hysteresis to: %d mV ...",j);
                        datapacket.cmd=USB_CLOCK_SET_HYSTERESIS;
                        datapacket.sethysteresislow=j;
                        datapacket.sethysteresishigh=(j>>8);
                        res=MPUSBWrite(myOutPipe,&datapacket,EPSIZE,&nb,USBTIMEOUT);
                        if(res==MPUSB_SUCCESS)
                        {
                        res=MPUSBRead(myInPipe, &indatapacket, 64, &nb, 500);
                        if(res==MPUSB_SUCCESS)
                        {
                        printf("Ok.\n");
                        if(m+1==argc)showInfo(&indatapacket);
                        }
                        else
                        {
                        printf("Error.\n");
                        }
                        } else printf("Error.\n");
                        
                        } else
                        {
                        printf("Device is not open!\n");
                        }
                    } else printf("Syntax error. Please provide an argument.\n");
                } else
                if(argv[m][1]=='p')
                {
                    // set the PWM Duty cycle for low power mode
                    if(argv[m][2]==':')
                    {
                        myargument=(int)atof(&argv[m][3]);
                        if(myargument<=0)myargument=0; else if(myargument>99)myargument=100;
                        i=openDevice();
                        if(i==0)
                        {
                        printFailedToOpenDeviceMessage();
                        } else
                        if(i==1)
                        {
                        
                        printf("Setting the low power PWM duty to: %d%c ...", (myargument), '%');
                        datapacket.cmd=USB_CLOCK_SET_PWM;
                        datapacket.pwmduty=myargument;
                        res=MPUSBWrite(myOutPipe,&datapacket,EPSIZE,&nb,USBTIMEOUT);
                        if(res==MPUSB_SUCCESS)
                        {
                        res=MPUSBRead(myInPipe, &indatapacket, 64, &nb, 500);
                        if(res==MPUSB_SUCCESS)
                        {
                        printf("Ok.\n");
                        if(m+1==argc)showInfo(&indatapacket);
                        }
                        else
                        {
                        printf("Error.\n");
                        }
                        } else printf("Error.\n");
                        
                        } else
                        {
                        printf("Device is not open!\n");
                        }
                    } else printf("Syntax error. Please provide an argument.\n");      
                } else
                if(argv[m][1]=='t')
                {
                    // set the back lighting timeout period
                    if(argv[m][2]==':')
                    {
                        myargument=(int)atof(&argv[m][3]);
                        if(myargument<1.0)myargument=1.0; else if(myargument>32000.0)myargument=32000.0;
                        i=openDevice();
                        if(i==0)
                        {
                        printFailedToOpenDeviceMessage();
                        } else
                        if(i==1)
                        {
                        printf("Setting the Backlight timeout period to: %d second(s) ...", (int)(myargument));
                        datapacket.timeouthigh=(byte)(myargument>>8);
                        datapacket.timeoutlow=(byte)myargument;
                        datapacket.cmd=USB_CLOCK_SET_TIMEOUT;
                        res=MPUSBWrite(myOutPipe,&datapacket,EPSIZE,&nb,USBTIMEOUT);
                        if(res==MPUSB_SUCCESS)
                        {
                        res=MPUSBRead(myInPipe, &indatapacket, 64, &nb, 500);
                        if(res==MPUSB_SUCCESS)
                        {
                        printf("Ok.\n");
                        if(m+1==argc)showInfo(&indatapacket);
                        }
                        else
                        {
                        printf("Error.\n");
                        }
                        } else printf("Error.\n");
                        
                        } else
                        {
                        printf("Device is not open!\n");
                        }
                    } else printf("Syntax error. Please provide an argument.\n");                     
                } else
                if(argv[m][1]=='z')
                {
                    // set the scrolling mode
                    if(argv[m][2]==':')
                    {
                        myargument=(int)atof(&argv[m][3]);
                        i=openDevice();
                        if(i==0)
                        {
                        printFailedToOpenDeviceMessage();
                        } else
                        if(i==1)
                        {
                        printf("Setting the default display mode to: %d ...", (int)(myargument));
                        datapacket.setscrollingmode=(byte)myargument;
                        datapacket.cmd=USB_CLOCK_SET_SCROLLING_MODE;
                        res=MPUSBWrite(myOutPipe,&datapacket,EPSIZE,&nb,USBTIMEOUT);
                        if(res==MPUSB_SUCCESS)
                        {
                        res=MPUSBRead(myInPipe, &indatapacket, 64, &nb, 500);
                        if(res==MPUSB_SUCCESS)
                        {
                        printf("Ok.\n");
                        if(m+1==argc)showInfo(&indatapacket);
                        }
                        else
                        {
                        printf("Error.\n");
                        }
                        } else printf("Error.\n");
                        
                        } else
                        {
                        printf("Device is not open!\n");
                        }
                    } else printf("Syntax error. Please provide an argument.\n");                     
                } else
                if(argv[m][1]=='a')
                {
                    // set the auto backlight mode
                    if(argv[m][2]==':')
                    {
                        myargument=(int)atof(&argv[m][3]);
                        myargument= myargument & 3;
                        i=openDevice();
                        if(i==0)
                        {
                        printFailedToOpenDeviceMessage();
                        } else
                        if(i==1)
                        {
                        printf("Setting the automatic backlight mode to: %d ...", (int)(myargument));
                        datapacket.tosetautobacklightmode=(byte)myargument;
                        datapacket.cmd=USB_CLOCK_SET_AUTO_BACKLIGHT_MODE;
                        res=MPUSBWrite(myOutPipe,&datapacket,EPSIZE,&nb,USBTIMEOUT);
                        if(res==MPUSB_SUCCESS)
                        {
                        res=MPUSBRead(myInPipe, &indatapacket, 64, &nb, 500);
                        if(res==MPUSB_SUCCESS)
                        {
                        printf("Ok.\n");
                        if(m+1==argc)showInfo(&indatapacket);
                        }
                        else
                        {
                        printf("Error.\n");
                        }
                        } else printf("Error.\n");
                        
                        } else
                        {
                        printf("Device is not open!\n");
                        }
                    } else printf("Syntax error. Please provide an argument.\n");                     
                } else
                if(argv[m][1]=='y')
                {
                    // set the twenty four hour time mode
                    if(argv[m][2]==':')
                    {
                        myargument=(int)atof(&argv[m][3]);
                        i=openDevice();
                        if(i==0)
                        {
                        printFailedToOpenDeviceMessage();
                        } else
                        if(i==1)
                        {
                        printf("Setting the twenty four hour time mode to: %d ...", (int)(myargument));
                        datapacket.settwentyfourhourtime=(byte)myargument;
                        datapacket.cmd=USB_CLOCK_SET_TWENTYFOURHOUR_MODE;
                        res=MPUSBWrite(myOutPipe,&datapacket,EPSIZE,&nb,USBTIMEOUT);
                        if(res==MPUSB_SUCCESS)
                        {
                        res=MPUSBRead(myInPipe, &indatapacket, 64, &nb, 500);
                        if(res==MPUSB_SUCCESS)
                        {
                        printf("Ok.\n");
                        if(m+1==argc)showInfo(&indatapacket);
                        }
                        else
                        {
                        printf("Error.\n");
                        }
                        } else printf("Error.\n");
                        
                        } else
                        {
                        printf("Device is not open!\n");
                        }
                    } else printf("Syntax error. Please provide an argument.\n");                     
                } else
                if(argv[m][1]=='b')
                {
                    // set the battery installed status
                    if(argv[m][2]==':')
                    {
                        myargument=(int)atof(&argv[m][3]);
                        i=openDevice();
                        if(i==0)
                        {
                        printFailedToOpenDeviceMessage();
                        } else
                        if(i==1)
                        {
                        printf("Setting the battery installed status to: %d ...", (int)(myargument));
                        datapacket.setnobatterymode=(byte)myargument;
                        datapacket.cmd=USB_CLOCK_SET_NOBATTERY;
                        res=MPUSBWrite(myOutPipe,&datapacket,EPSIZE,&nb,USBTIMEOUT);
                        if(res==MPUSB_SUCCESS)
                        {
                        res=MPUSBRead(myInPipe, &indatapacket, 64, &nb, 500);
                        if(res==MPUSB_SUCCESS)
                        {
                        printf("Ok.\n");
                        if(m+1==argc)showInfo(&indatapacket);
                        }
                        else
                        {
                        printf("Error.\n");
                        }
                        } else printf("Error.\n");
                        
                        } else
                        {
                        printf("Device is not open!\n");
                        }
                    } else printf("Syntax error. Please provide an argument.\n");                     
                } else
                if(argv[m][1]=='d')
                {
                    // set the display timeout period
                    if(argv[m][2]==':')
                    {
                        myargument=(int)atof(&argv[m][3]);
                        if(myargument<1.0)myargument=1.0; else if(myargument>32000.0)myargument=32000.0;
                        i=openDevice();
                        if(i==0)
                        {
                        printFailedToOpenDeviceMessage();
                        } else
                        if(i==1)
                        {
                        printf("Setting the display timeout period to: %d second(s) ...", (int)(myargument));
                        datapacket.setdisplaytimeouthigh=(byte)(myargument>>8);
                        datapacket.setdisplaytimeoutlow=(byte)myargument;
                        datapacket.cmd=USB_CLOCK_SET_DISPLAY_TIMEOUT;
                        res=MPUSBWrite(myOutPipe,&datapacket,EPSIZE,&nb,USBTIMEOUT);
                        if(res==MPUSB_SUCCESS)
                        {
                        res=MPUSBRead(myInPipe, &indatapacket, 64, &nb, 500);
                        if(res==MPUSB_SUCCESS)
                        {
                        printf("Ok.\n");
                        if(m+1==argc)showInfo(&indatapacket);
                        }
                        else
                        {
                        printf("Error.\n");
                        }
                        } else printf("Error.\n");
                        
                        } else
                        {
                        printf("Device is not open!\n");
                        }
                    } else printf("Syntax error. Please provide an argument.\n");                     
                }
                else
                if(argv[m][1]=='r')
                {
                    // reset the USB Clock
                    i=openDevice();
                    if(i==0)
                    {
                        printFailedToOpenDeviceMessage();
                        
                    } else
                    if(i==1)
                    {
                        
                        printf("Resetting the USB Clock...");
                        datapacket.cmd=USB_CLOCK_RESET;
                        res=MPUSBWrite(myOutPipe,&datapacket,EPSIZE,&nb,USBTIMEOUT);
                        
                        
                    } else
                    {
                        printf("Device is not open!\n");
                    }  
                } else
                if(argv[m][1]=='c')
                {
                    //  set the reference sense resistor in mOhms
                    myargument=0;
                    if(argv[m][2]==':')
                    {
                        myargument=(int)atof(&argv[m][3]);
                        i=openDevice();
                        if(i==0)
                        {
                        printFailedToOpenDeviceMessage();
                        } else
                        if(i==1)
                        {
                        printf("Setting the reference sense resistor value to: %d m%c...", (int)myargument, 234);
                        datapacket.cmd=USB_CLOCK_SET_SENSE_RESISTOR;
                        datapacket.setsenseresistorhigh=(byte)(myargument>>8);
                        datapacket.setsenseresistorlow=(byte)myargument;
                        res=MPUSBWrite(myOutPipe,&datapacket,EPSIZE,&nb,USBTIMEOUT);
                        if(res==MPUSB_SUCCESS)
                        {
                        res=MPUSBRead(myInPipe, &indatapacket, 64, &nb, 500);
                        if(res==MPUSB_SUCCESS)
                        {
                        printf("Ok.\n");
                        if(m+1==argc)showInfo(&indatapacket);
                        }
                        else
                        {
                        printf("Error.\n");
                        }
                        } else printf("Error.\n");
                        
                        } else
                        {
                        printf("Device is not open!\n");
                        }
                    } else printf("Syntax error. Please provide an argument.\n");
              
                } else
                if(argv[m][1]=='v')
                {
                    //  set the reference voltage in mV
                    myargument=0;
                    if(argv[m][2]==':')
                    {
                        myargument=(int)atof(&argv[m][3]);
                        i=openDevice();
                        if(i==0)
                        {
                        printFailedToOpenDeviceMessage();
                        } else
                        if(i==1)
                        {
                        printf("Setting the reference voltage to: %d mV...", (int)myargument);
                        datapacket.cmd=USB_CLOCK_SET_VOLTAGE_REFERENCE;
                        datapacket.setvoltagerefhigh=(byte)(myargument>>8);
                        datapacket.setvoltagereflow=(byte)myargument;
                        res=MPUSBWrite(myOutPipe,&datapacket,EPSIZE,&nb,USBTIMEOUT);
                        if(res==MPUSB_SUCCESS)
                        {
                        res=MPUSBRead(myInPipe, &indatapacket, 64, &nb, 500);
                        if(res==MPUSB_SUCCESS)
                        {
                        printf("Ok.\n");
                        if(m+1==argc)showInfo(&indatapacket);
                        }
                        else
                        {
                        printf("Error.\n");
                        }
                        } else printf("Error.\n");
                        
                        } else
                        {
                        printf("Device is not open!\n");
                        }
                    } else printf("Syntax error. Please provide an argument.\n");
              
                } else
                {
                    printf("Try one of the following options instead:\n");
                    showHelpScreen();
            }
            } else
            {
                printf("Syntax Error. Try one of the following options:\n");
                showHelpScreen();
            }
            m++;
        }  
}
  
  /*  
    while(!bQuit)
    {
        printf("[1] Get MPUSBAPI Version\r\n");
        printf("[2] Summarize Instances\r\n");
        printf("[3] Open USB device\r\n");
        printf("[4] Send and Receive Command Packets\r\n");
        printf("[5] Set Command\r\n");
        printf("[6] Update Time\r\n");
        printf("[7] Update Time Continuous\r\n");
        printf("[X] Quit\r\n>>");
        fflush(stdin);
        scanf("%c",&selection);        
        switch(selection)
        {
            case '1':
                temp = MPUSBGetDLLVersion();
                printf("MPUSBAPI Version: %d.%d\r\n",HIWORD(temp),LOWORD(temp));
                break;
            case '2':
                GetSummary();
                break;
            case '3':
                if(open==0){
                maxn = MPUSBGetDeviceCount(vid_pid);
                myOutPipe = INVALID_HANDLE_VALUE;
                myOutPipe = MPUSBOpen(0,vid_pid,out_pipe,MP_WRITE,0);
                myInPipe  = INVALID_HANDLE_VALUE;
                myInPipe  = MPUSBOpen(0,vid_pid,in_pipe,MP_READ,0);
                printf("USB Device Open...... ");
                if((myInPipe!=INVALID_HANDLE_VALUE)&&(myOutPipe!=INVALID_HANDLE_VALUE))
                {
                 printf("Ok.\n");
                 open=1;
                 }
                 else
                 {
                 printf("Error.\n");
                 open=0;
                 }
                }
                else printf("Device is already open.\n");
                break;
            case '4':
                 if(open!=0)
                 {
                 datapacket.cmd=current_command;
                 printf("Write Data...... ");
                 res=MPUSBWrite(myOutPipe,&datapacket,EPSIZE,&nb,USBTIMEOUT);
                 
                 if(res==MPUSB_SUCCESS)
                 {
                     printf("Ok. Bytes written= %d.\n", nb);
                     showPacket(&datapacket._byte[0],nb);
                 }
                 else
                 {
                         printf("Error.\n");
                         break;
                 }
                 printf("Read Data...... ");
                 res=MPUSBRead(myInPipe, &indatapacket, 64, &nb, 500);
                 
                 if(res==MPUSB_SUCCESS)
                 { 
                     printf("OK. Bytes read= %d.\n", nb);
                     showPacket(&indatapacket._byte[0],nb);
                 }
                 else
                 {
                     printf("Error.\n");
                     break;      
                 }
                 }
                 else
                 {
                     printf("Device is not open!\n");
                 }
                 break;
            case '5':
                 printf(" [a] GET OK BUTTON  \r\n");
                 printf(" [b] GET DATA IN BIT \r\n");
                 printf(" [c] SET LEDS \r\n");
                 printf(" [d] SET VPP      \r\n");
                 printf(" [e] SET VDD \r\n");
                 printf(" [f] SET CLOCK AND DATA \r\n");
                 printf(" [g] SET CLOCK ENABLE \r\n");
                 printf(" [h] SET DATA ENABLE \r\n");
                 printf(" [i] PULL MCLR TO GND \r\n");
                 printf(" [j] CONNECT TARGET \r\n");
                 printf(" [k] USB_CLOCK_SET \r\n");
                 fflush(stdin);
                 scanf("%c",&selection);
                 switch(selection)
                 {
                  case 'a':
                       current_command=WINPIC_GETOKBUTTON;
                       break;
                  case 'b':
                       current_command=WINPIC_GETDATAINBIT;
                       break;
                  case 'c':
                       current_command=WINPIC_SETLEDS;
                       datapacket.led_bank=ledcounter;
                       ledcounter++;
                       break;
                  case 'd':
                       current_command=WINPIC_SETVPP;
                       datapacket.vpp_level=1;
                       datapacket.vpp_voltage=13.0;
                       break;
                  case 'e':
                       current_command=WINPIC_SETVDD;
                       datapacket.vdd_level=1;
                       datapacket.vdd_voltage=5.0;
                       break;
                  case 'f':
                       current_command=WINPIC_SETCLOCKANDDATA;
                       datapacket.pgc=(pgccounter & 0x01);
                       datapacket.pgd=(pgccounter & 0x02)>>1;
                       pgccounter++;
                       break;
                  case 'g':
                       current_command=WINPIC_SETCLOCKENABLE;
                       break;
                  case 'h':
                       current_command=WINPIC_SETDATAENABLE;
                       break;
                  case 'i':
                       current_command=WINPIC_PULLMCLRTOGND;
                       break;
                  case 'j':
                       current_command=WINPIC_CONNECTTARGET;
                       break;
                  case 'k':
                       current_command=USB_CLOCK_SET;
                       datapacket.minutes=0x13;
                       break;
                  default:
                       break;               
                 }
                 datapacket.cmd=current_command;
                 printf("Ready to send......\n");
                 showPacket(&datapacket._byte[0],8);
                 break;
            case '6':
                updateTime();
                current_command=USB_CLOCK_SET;
                datapacket.hours=theLocalTime->tm_hour;
                datapacket.minutes=theLocalTime->tm_min;
                datapacket.seconds=theLocalTime->tm_sec;
                printf("Updating Time...\r\n");
                printf("Hours: %d Minutes: %d Seconds: %d\r\n", datapacket.hours, datapacket.minutes, datapacket.seconds);
                if(open!=0)
                 {
                 datapacket.cmd=current_command;
                 printf("Write Data...... ");
                 res=MPUSBWrite(myOutPipe,&datapacket,EPSIZE,&nb,USBTIMEOUT);
                 
                 if(res==MPUSB_SUCCESS)
                 {
                     printf("Ok. Bytes written= %d.\n", nb);
                     showPacket(&datapacket._byte[0],nb);
                 }
                 else
                 {
                         printf("Error.\n");
                         printf("Closing ALL Handles.\n");
                         MPUSBClose(myInPipe);
                         MPUSBClose(myOutPipe);
                         open=0;
                         break;
                 }
                 printf("Read Data...... ");
                 res=MPUSBRead(myInPipe, &indatapacket, 64, &nb, 500);
                 
                 if(res==MPUSB_SUCCESS)
                 { 
                     printf("OK. Bytes read= %d.\n", nb);
                     showPacket(&indatapacket._byte[0],nb);
                 }
                 else
                 {
                     printf("Error.\n");
                     printf("Closing ALL Handles.\n");
                     MPUSBClose(myInPipe);
                     MPUSBClose(myOutPipe);
                     open=0; 
                     break;      
                 }
                 }
                 else
                 {
                     printf("Device is not open!\n");
                 }
               break;
           case '7':
                for(jj=0; jj<60;jj++)
                {
                                
                updateTime();
                current_command=USB_CLOCK_SET;
                datapacket.hours=theLocalTime->tm_hour;
                datapacket.minutes=theLocalTime->tm_min;
                while(datapacket.seconds==theLocalTime->tm_sec)updateTime();
                datapacket.seconds=theLocalTime->tm_sec;
                printf("Updating Time...\r\n");
                printf("Hours: %d Minutes: %d Seconds: %d\r\n", datapacket.hours, datapacket.minutes, datapacket.seconds);
                if(open!=0)
                 {
                 datapacket.cmd=current_command;
                 printf("Write Data...... ");
                 res=MPUSBWrite(myOutPipe,&datapacket,EPSIZE,&nb,USBTIMEOUT);
                 
                 if(res==MPUSB_SUCCESS)
                 {
                     printf("Ok. Bytes written= %d.\n", nb);
                     showPacket(&datapacket._byte[0],nb);
                 }
                 else
                 {
                         printf("Error.\n");
                 
                 }
                 printf("Read Data...... ");
                 res=MPUSBRead(myInPipe, &indatapacket, 64, &nb, 500);
                 
                 if(res==MPUSB_SUCCESS)
                 { 
                     printf("OK. Bytes read= %d.\n", nb);
                     showPacket(&indatapacket._byte[0],nb);
                 }
                 else
                 {
                     printf("Error.\n");
                 
                 }
                 }
                 else
                 {
                     printf("Device is not open!\n");
                 }
                   
                    
                }
               break;
            case 'X':
                bQuit = true;
                break;
            default:
                break;
        }// end switch

        fflush(stdin);printf("\r\n");
    }//end while
    */
    
    printf("Exiting...\n");
    // Always check to close all handles before exiting!
    if (myOutPipe != INVALID_HANDLE_VALUE)MPUSBClose(myOutPipe);
    if (myInPipe  != INVALID_HANDLE_VALUE)MPUSBClose(myInPipe);
    myOutPipe = myInPipe = INVALID_HANDLE_VALUE;
    return 0;
}//end main

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------

